unit Express;
{$F+}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, pars, parsglb, SynDlg;

type
  TExpress = class(TComponent)
  private
    fparse:pparse;
    fparlist:TParString;
    fvarlist:TVarString;
    fparvalues:TParValues;
    fMessageOnError:boolean;
    fErrorMessage:string;
    fExpression:string;
    fSyntaxText:TStrings;
    fSyntaxDialog:TSyntaxDialog;
    procedure SetExpression(expr:string);
    procedure SetSyntaxText(Text:TStrings);
    { Private declarations }
  protected
    { Protected declarations }
  public
    Error:boolean;
    {read the value of Error to check whether the current expression has
    valid syntax}

    constructor create(AOwner:TComponent); override;
    destructor destroy; override;

    function TheFunction(x,y,z: extended):extended;
    {Call TheFunction to evaluate the current expression. Before you make
    any calls to TheFunction, check that the expression has valid syntax
    (->Error). If you call TheFunction for an invalid expression you get
    a GPF}

    procedure ShowSyntax;
    {Display a pop up form that explains the expression syntax. Contents can
    be modified using the SyntaxText property}

    procedure SetParameters(p1,p2,p3,p4,p5,p6:extended);
    {Set parameter values for the available 6 parameters -> SyntaxText property}

    { Public declarations }
  published
    property Expression:string read fexpression write SetExpression;
    {Expression is the string to be evaluated. For syntax -> SyntaxText property}

    property VariableList:TVarString read fvarlist write fvarlist;
    {String containing the characters for the 3 possible variables}

    property ParameterList:TParString read fparlist write fparlist;
    {String containing the characters for the 6 possible parameters}

    property MessageOnError:boolean read fMessageOnError write fMessageOnError;
    {If true, you can yell at the user if the syntax is wrong. -> ErrorMessage}

    property ErrorMessage:string read fErrorMessage write fErrorMessage;
    {Message string to be displayed on syntax error, if MessageOnError is true}

    property SyntaxText:TStrings read fSyntaxtext write setSyntaxtext;
    {Text explaining the expression syntax. Read the default in the property
    editor of the component for a basic explanation. You can modify this to
    your conveniance.}

    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TExpress]);
end;


function TExpress.TheFunction(x,y,z:extended):extended;
begin
  fparse^.f(x,y,z,result);
end;

constructor TExpress.Create;
var i:integer;
begin
  inherited create(aowner);
  fparse:=nil;
  fMessageOnError:=true;
  fvarlist:='xyz';
  fparlist:='abcdef';
  for i:=1 to 6 do
  fparvalues[i]:=1;
  fExpression:='x';
  fSyntaxDialog:=TSyntaxDialog.Create(nil);
  fSyntaxtext:=TSTringlist.create;
  With fSyntaxText do
  begin
    add('Enter Expressions for functions of up to 3 variables:');
    add('    x   y   and   z');
    add('');
    add('You can change the names of the variables using the');
    add('VariableList property');
    add('');
    add('Basic operations are denoted by');
    add('');
    add('   +   -    * (Multiplication)   / (Division)   ^ (Power).');
    add('');
    add('Leaving out the   *   in a multiplication causes an error.');
    add('');
    add('Example: 4.5*x/(y^2-z)  is a valid expression');
    add('');
    add('Everything is case sensitive.');
    add('');
    add('The following standard functions are supported:');
    add('');
    add('sin, cos, exp, ln, sqrt(square root), arctan, ');
    add('sinh, cosh, tan, cot, arcsin, arccos ');
    add('');
    add('Some supported non standard functions are:');
    add('');
    add('min:   min(x,y) is the minimum of x and y');
    add('max:   max(x,y) is the maximum of x and y');
    add('arg:   arg(x,y) is the angle of (x,y) with the line y=0');
    add('  lt:   lt(x,y) = 1, if x<y,  = 0 otherwise');
    add('  le:   le(x,y) = 1, if x<=y, = 0 otherwise');
    add('  eq:   eq(x,y) = 1, if x=y,  = 0 otherwise');
    add('  ne:   ne(x,y) = 1, if x<>y, = 0 otherwise');
    add('');
    add('The last four functions can be used to implement');
    add('split definitions, like:');
    add('');
    add('     ln(x*y)*lt(0.1,x*y)+ln(0.1)*le(x*y,0)  ');
    add('');
    add('If you care to read the source, you''ll find more functions.');
    add('');
    add('Special constants: ');
    add('Only   pi   is supported.');
    add('Instead of   e   use exp(1).');
    add('');
    add('  Info for component- but not necessarily end- users:');
    add('');
    add('In addition to the 3 variables, the expression can');
    add('depend on up to 6 parameters, intended to be "variables');
    add('that don''t vary as much as the variables"');
    add('Their names are set in the ParameterList property, and');
    add('their values can be assigned by the SetParameters procedure.');
    add('Effectively, you can mimic a function of up to 9 variables');
    add('this way.');
    add('The expression gets evaluated by a call to TheFunction.');
    add('Possible floating point exceptions are being avoided by');
    add('setting a result to 0 whenever it is undefined.');
    add('(Is faster than exception handling)');
    add('But as a result, TheFunction might compute junk without');
    add('the user noticing.');
  end;
  fErrorMessage:='Syntax Error';
end;

procedure TExpress.SetExpression(expr:string);
var p:array[0..254] of Char; i:integer;
begin
  if fparse<>nil then dispose(fparse,done);
  fparse:=new(pparse,init(expr,fvarlist,fparlist,error));
  if error then
  begin
    dispose(fparse,done);
    fparse:=nil;
    if fMessageOnError then
    begin
      for i:=0 to length(fErrorMessage)-1 do
      p[i]:=fErrorMessage[i+1];
      p[length(fErrorMessage)]:=#0;
      messagebox(GetFocus,@p,'Express',MB_ICONHAND or MB_OK)
    end;
  end else
  begin
    fparse^.setparams(fparvalues);
  end;
end;

Procedure TExpress.SetSyntaxText;
begin
  fSyntaxText.assign(Text);
end;

Procedure TExpress.ShowSyntax;
begin
  fSyntaxDialog.listbox1.Items.assign(Syntaxtext);
  fSyntaxDialog.showmodal;
end;

procedure TExpress.setparameters;
begin
  if fparse<>nil then
  begin
    fparvalues[1]:=p1; fparvalues[2]:=p2; fparvalues[3]:=p3;
    fparvalues[4]:=p4; fparvalues[5]:=p5; fparvalues[6]:=p6;
    fparse^.setparams(fparvalues);
  end;
end;

Destructor TExpress.destroy;
begin
  inherited destroy;
  fSyntaxDialog.free;
  if fparse<>nil then dispose(fparse,done);
  fSyntaxtext.free;
end;

end.

